/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.parsing;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLDocumentTypes {
    private static final String HTML_2_0 = "-//IETF//DTD HTML//EN";
    private static final String HTML_3_2 = "-//W3C//DTD HTML 3.2 Final//EN";
    private static final String HTML_4_0_1_STRICT = "-//W3C//DTD HTML 4.01//EN";
    private static final String HTML_4_0_1_TRANSITIONAL = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private static final String HTML_4_0_1_FRAMESET = "-//W3C//DTD HTML 4.01 Frameset//EN";
    private static final String XHTML_1_0_STRICT = "-//W3C//DTD XHTML 1.0 Strict//EN";
    private static final String XHTML_1_0_TRANSITIONAL = "-//W3C//DTD XHTML 1.0 Transitional//EN";
    private static final String XHTML_1_0_FRAMESET = "-//W3C//DTD XHTML 1.0 Frameset//EN";
    private static final String XHTML_1_1_STRICT = "-//W3C//DTD XHTML 1.1//EN";
    private static final Pattern DOCTYPE_PATTERN = Pattern.compile("<!DOCTYPE\\s+(\\S+)\\s+PUBLIC\\s+((?:'[^']+')|(?:\"[^\"]+\"))(?:\\s+((?:'[^']+')|(?:\"[^\"]+\")))?");
    private static final Map<String, Type> fDocTypes = new HashMap<String, Type>();

    static {
        fDocTypes.put(HTML_2_0, Type.HTML_2_0);
        fDocTypes.put(HTML_3_2, Type.HTML_3_2);
        fDocTypes.put(HTML_4_0_1_STRICT, Type.HTML_4_0_1_STRICT);
        fDocTypes.put(HTML_4_0_1_TRANSITIONAL, Type.HTML_4_0_1_TRANSITIONAL);
        fDocTypes.put(HTML_4_0_1_FRAMESET, Type.HTML_4_0_1_FRAMESET);
        fDocTypes.put(XHTML_1_0_STRICT, Type.XHTML_1_0_STRICT);
        fDocTypes.put(XHTML_1_0_TRANSITIONAL, Type.XHTML_1_0_TRANSITIONAL);
        fDocTypes.put(XHTML_1_0_FRAMESET, Type.XHTML_1_0_FRAMESET);
        fDocTypes.put(XHTML_1_1_STRICT, Type.XHTML_1_1_STRICT);
    }

    public static Type getType(String source) {
        Matcher match;
        Type documentType = Type.OTHER;
        int indexOf = source.indexOf("<!DOCTYPE");
        if (indexOf > -1 && (match = DOCTYPE_PATTERN.matcher(source.substring(indexOf))).find()) {
            String rootElement = match.group(1);
            String pubId = match.group(2);
            pubId = pubId.substring(1, pubId.length() - 1);
            if ((rootElement.equals("html") || rootElement.equals("HTML")) && fDocTypes.containsKey(pubId)) {
                documentType = fDocTypes.get(pubId);
            }
        }
        return documentType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        OTHER,
        HTML_2_0,
        HTML_3_2,
        HTML_4_0_1_STRICT,
        HTML_4_0_1_TRANSITIONAL,
        HTML_4_0_1_FRAMESET,
        HTML_5_0,
        XHTML_1_0_STRICT,
        XHTML_1_0_TRANSITIONAL,
        XHTML_1_0_FRAMESET,
        XHTML_1_1_STRICT;

    }
}

